<?php
if (!defined('__TYPECHO_ROOT_DIR__')) exit;

function themeConfig($form) {
    $logoUrl = new Typecho_Widget_Helper_Form_Element_Text('logoUrl', NULL, NULL, _t('站点LOGO地址'), _t('在这里填入一个图片URL地址, 以在网站标题前加上一个LOGO'));
    $form->addInput($logoUrl);
    $favicon = new Typecho_Widget_Helper_Form_Element_Text('favicon', NULL, NULL, _t('favicon地址'), _t('一般为http://www.yourblog.com/image.png,支持 https:// 或 //,留空则不设置favicon'));
    $form->addInput($favicon);

    $icp = new Typecho_Widget_Helper_Form_Element_Text('icp', NULL, NULL, _t('底部网站信息&备案号'), _t('在这里填入你的网站信息&备案号， 例如：© 2019 悦图网 - Theme by Spinyue鄂ICP备15008888号-1'));
    $form->addInput($icp);
    $sitedate = new Typecho_Widget_Helper_Form_Element_Text('sitedate', NULL, NULL, _t('网站建站日期'), _t('在这里填入你的网站建站日期， 例如：2017-05-20'));
    $form->addInput($sitedate);
    $zztj = new Typecho_Widget_Helper_Form_Element_Text('zztj', NULL, NULL, _t('网站统计代码'), _t('在这里填入你的网站统计代码，这个可以到百度统计或者cnzz上申请。'));
    $form->addInput($zztj);
    $adlink = new Typecho_Widget_Helper_Form_Element_Text('adlink', NULL, NULL, _t('广告链接地址'), _t('在这里填入你广告链接地址，http://www.yourblog.com,支持 https:// 或 //'));
    $form->addInput($adlink);
    $adimg = new Typecho_Widget_Helper_Form_Element_Text('adimg', NULL, NULL, _t('广告图片链接地址'), _t('在这里填入你广告图片链接地址，http://www.yourblog.com/image.png,支持 https:// 或 //'));
    $form->addInput($adimg);

    $imghdp = new Typecho_Widget_Helper_Form_Element_Text('imghdp', NULL, NULL, _t('首页头条文章ID'), _t('在这里填入头条文章ID'));
    $form->addInput($imghdp);

    $footernav = new Typecho_Widget_Helper_Form_Element_Textarea('footernav', NULL, NULL, _t('底部链接（友情链接）'), _t('一行一个链接，格式为：&lt;a rel="nofollow" target="_blank" href="//mrju.cn"&gt;MrJu&lt;/a&gt;'));
    $form->addInput($footernav);    

	$tophdp = new Typecho_Widget_Helper_Form_Element_Text('tophdp', NULL, NULL, _t('话题栏目ID'), _t('话题栏目ID号，填入分类栏目的ID'));
    $form->addInput($tophdp);

}


//博客最后更新时间
function get_last_update(){
    $num   = '1'; //取最近的一笔就好了
    $now = time();
    $db     = Typecho_Db::get();
    $prefix = $db->getPrefix();
    $create = $db->fetchRow($db->select('created')->from('table.contents')->limit($num)->order('created',Typecho_Db::SORT_DESC));
    $update = $db->fetchRow($db->select('modified')->from('table.contents')->limit($num)->order('modified',Typecho_Db::SORT_DESC));
    if($create>=$update){  //发表时间和更新时间取最近的
      echo Typecho_I18n::dateWord($create['created'], $now); //转换为更通俗易懂的格式
    }else{
      echo Typecho_I18n::dateWord($update['modified'], $now);
    }
}


//随机文章
function getRandomPosts($limit = 10){    
    $db = Typecho_Db::get();
    $result = $db->fetchAll($db->select()->from('table.contents')
        ->where('status = ?','publish')
        ->where('type = ?', 'post')
        ->where('created <= unix_timestamp(now())', 'post')
        ->limit($limit)
        ->order('RAND()')
    );
    if($result){
        $i=1;
        foreach($result as $val){
            if($i<=3){
                $var = ' class="red"';
            }else{
                $var = '';
            }
            $val = Typecho_Widget::widget('Widget_Abstract_Contents')->push($val);
            $post_title = htmlspecialchars($val['title']);
            $permalink = $val['permalink'];
            echo '<li><div class="widget-posts-text"><a class="widget-posts-title" href="'.$permalink.'" title="'.$post_title.'">'.$post_title.'</a><div class="widget-posts-meta"><i>'.$val['commentsNum'].'评论</i></div></div></li>';
            $i++;
        }
    }
}




//后台编辑器添加功能
function themeFields($layout) {
    $img = new Typecho_Widget_Helper_Form_Element_Text('img', NULL, NULL, _t('自定义缩略图'), _t('在这里填入一个图片 URL 地址, 以添加显示本文的缩略图，留空则显示默认缩略图'));
    $img->input->setAttribute('class', 'w-100');
    $layout->addItem($img);


    $catalog = new Typecho_Widget_Helper_Form_Element_Radio('catalog', 
    array(true => _t('启用'),
    false => _t('关闭')),
    false, _t('文章目录'), _t('默认关闭，启用则会在文章内显示“文章目录”（若文章内无任何 h3 标题，则不显示目录）'));
    $layout->addItem($catalog);
}


//热门文章
function getHotPosts($limit = 10){
    $db = Typecho_Db::get();
    $result = $db->fetchAll($db->select()->from('table.contents')
        ->where('status = ?','publish')
        ->where('type = ?', 'post')
        ->where('created <= unix_timestamp(now())', 'post') //添加这一句避免未达到时间的文章提前曝光
        ->limit($limit)
        ->order('commentsNum', Typecho_Db::SORT_DESC)
    );
    if($result){
        foreach($result as $val){            
            $val = Typecho_Widget::widget('Widget_Abstract_Contents')->push($val);
            $post_title = htmlspecialchars($val['title']);
            $permalink = $val['permalink'];
            echo '<li><div class="widget-posts-text"><a class="widget-posts-title" href="' .$permalink. '" title="' .$post_title. '">' .$post_title. '</a><div class="widget-posts-meta"><i>' . $val['commentsNum'] . ' 评论</i></div></div></li>';        
        }
    }
}


/**
* 阅读统计
* 调用<?php get_post_view($this); ?>
*/
function Postviews($archive) {
    $db = Typecho_Db::get();
    $cid = $archive->cid;
    if (!array_key_exists('views', $db->fetchRow($db->select()->from('table.contents')))) {
        $db->query('ALTER TABLE `'.$db->getPrefix().'contents` ADD `views` INT(10) DEFAULT 0;');
    }
    $exist = $db->fetchRow($db->select('views')->from('table.contents')->where('cid = ?', $cid))['views'];
    if ($archive->is('single')) {
        $cookie = Typecho_Cookie::get('contents_views');
        $cookie = $cookie ? explode(',', $cookie) : array();
        if (!in_array($cid, $cookie)) {
            $db->query($db->update('table.contents')
                ->rows(array('views' => (int)$exist+1))
                ->where('cid = ?', $cid));
            $exist = (int)$exist+1;
            array_push($cookie, $cid);
            $cookie = implode(',', $cookie);
            Typecho_Cookie::set('contents_views', $cookie);
        }
    }
    echo $exist == 0 ? '暂无阅读' : $exist.' 次阅读';
}


/**
* 评论者主页链接新窗口打开
* 调用<?php CommentAuthor($comments); ?>
*/
function CommentAuthor($obj, $autoLink = NULL, $noFollow = NULL) {    //后两个参数是原生函数自带的，为了保持原生属性，我并没有删除，原版保留
    $options = Helper::options();
    $autoLink = $autoLink ? $autoLink : $options->commentsShowUrl;    //原生参数，控制输出链接（开关而已）
    $noFollow = $noFollow ? $noFollow : $options->commentsUrlNofollow;    //原生参数，控制输出链接额外属性（也是开关而已...）
    if ($obj->url && $autoLink) {
        echo '<a href="'.$obj->url.'"'.($noFollow ? ' rel="external nofollow"' : NULL).(strstr($obj->url, $options->index) == $obj->url ? NULL : ' target="_blank"').'>'.$obj->author.'</a>';
    } else {
        echo $obj->author;
    }
}


